/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.lang.acl.ACLMessage;
import jade.util.leap.EnumIterator;
import jade.util.leap.Iterator;
import java.util.Vector;

class MessageQueue {
    private Vector list;
    private int maxSize;
    private Long persistentID;

    public MessageQueue(int size) {
        this.maxSize = size;
        this.list = new Vector();
    }

    public MessageQueue() {
        this(0);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void setMaxSize(int newSize) throws IllegalArgumentException {
        if (newSize < 0) {
            throw new IllegalArgumentException("Invalid MsgQueue size");
        }
        this.maxSize = newSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int size() {
        return this.list.size();
    }

    public void addFirst(ACLMessage msg) {
        if (this.maxSize != 0 && this.list.size() >= this.maxSize) {
            this.list.setElementAt(msg, 0);
        } else {
            this.list.insertElementAt(msg, 0);
        }
    }

    public void addLast(ACLMessage msg) {
        if (this.maxSize != 0 && this.list.size() >= this.maxSize) {
            this.list.removeElementAt(0);
        }
        this.list.addElement(msg);
    }

    public ACLMessage removeFirst() {
        ACLMessage msg = (ACLMessage)this.list.firstElement();
        this.list.removeElementAt(0);
        return msg;
    }

    public boolean remove(ACLMessage item) {
        return this.list.removeElement(item);
    }

    public Iterator iterator() {
        return new EnumIterator(this.list.elements());
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }
}

